package com.burhanstore.neonbubblequest.Utils

import android.app.Activity
import android.graphics.Color
import androidx.core.content.ContextCompat
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsControllerCompat
import com.burhanstore.neonbubblequest.R

object StatusStyle {
    fun setWindowStyling(activity: Activity) {
        val window = activity.window

        // Transparent status bar
        window.statusBarColor = Color.TRANSPARENT

        // Set navigation bar background
        window.navigationBarColor = ContextCompat.getColor(activity, R.color.app_bg)

        // Allow content to draw behind system bars
        WindowCompat.setDecorFitsSystemWindows(window, false)

        // Create controller for status & nav bars
        val controller = WindowInsetsControllerCompat(window, window.decorView)

        // ✅ Set black text/icons on status bar
        controller.isAppearanceLightStatusBars = true

        // Optional: Keep navigation icons light or dark as you prefer
        controller.isAppearanceLightNavigationBars = false
    }
}
